/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.google.common.collect.ImmutableList;
import com.imavis.tlc3000.network.client.entities.Camera;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class CamTableModel
extends AbstractTableModel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
    private final SortedMap<String, Camera> cameras = new TreeMap<String, Camera>();
    private List<String> serials = ImmutableList.of();

    public void addCamera(Camera camera) {
        this.cameras.put(camera.getSerial(), camera);
        this.serials = ImmutableList.copyOf(this.cameras.keySet());
        this.fireTableDataChanged();
    }

    public void reset() {
        this.cameras.clear();
        this.serials = ImmutableList.of();
        this.fireTableDataChanged();
    }

    public Camera getCamera(int rowIndex) {
        return (Camera)this.cameras.get(this.serials.get(rowIndex));
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String key;
        switch (columnIndex) {
            case 0: {
                key = "label.serial";
                break;
            }
            case 1: {
                key = "label.ip";
                break;
            }
            case 2: {
                key = "label.env_ip";
                break;
            }
            case 3: {
                key = "label.netmask";
                break;
            }
            case 4: {
                key = "label.gateway";
                break;
            }
            case 5: {
                key = "label.dns";
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected column: " + columnIndex));
            }
        }
        return BUNDLE.getString(key);
    }

    @Override
    public int getRowCount() {
        return this.serials.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Camera camera = this.getCamera(rowIndex);
        switch (columnIndex) {
            case 0: {
                return camera.getSerial();
            }
            case 1: {
                return camera.getIp();
            }
            case 2: {
                String env_ip = camera.getEnv_ip();
                return env_ip == null ? BUNDLE.getString("not_available") : env_ip;
            }
            case 3: {
                return camera.getNetmask();
            }
            case 4: {
                return camera.getGateway();
            }
            case 5: {
                return camera.getDns();
            }
        }
        throw new AssertionError((Object)("unexpected column: " + columnIndex));
    }
}

