/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SendingAddress {
    private static final Logger LOGGER = Logger.getLogger(SendingAddress.class.getName());
    private final InetAddress address;
    private final String name;

    private SendingAddress(NetworkInterface networkInterface, InterfaceAddress interfaceAddress) {
        this.address = interfaceAddress.getAddress();
        this.name = String.format("%s (%s)", networkInterface.getDisplayName(), this.address.getHostAddress());
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toString() {
        return this.name;
    }

    public static List<SendingAddress> getSendingAddresses() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(i -> {
                try {
                    return !i.isLoopback() && i.isUp();
                }
                catch (SocketException ex) {
                    LOGGER.log(Level.SEVERE, "error dealing with " + i.getName(), ex);
                    return false;
                }
            }).sorted(Comparator.comparing(NetworkInterface::getIndex)).flatMap(i -> i.getInterfaceAddresses().stream().filter(a -> a.getBroadcast() != null).map(a -> new SendingAddress((NetworkInterface)i, (InterfaceAddress)a))).collect(Collectors.toList());
        }
        catch (SocketException ex) {
            LOGGER.log(Level.SEVERE, "error getting network interfaces", ex);
            return Collections.emptyList();
        }
    }
}

