/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Dialogs {
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
    private static JFrame parentFrame = null;
    private static JDialog waitingDialog = null;

    public static void setParent(JFrame frame) {
        assert (EventQueue.isDispatchThread());
        parentFrame = frame;
    }

    public static String getTitleText(String text) {
        return text + " - " + BUNDLE.getString("title");
    }

    public static void showMessage(String messageKey, MessageType type, Object ... arguments) {
        String title = Dialogs.getTitleText(type.subtitle);
        String message = MessageFormat.format(BUNDLE.getString(messageKey), arguments);
        EventQueue.invokeLater(() -> {
            Dialogs.disposeWaitingDialog();
            JOptionPane.showMessageDialog(parentFrame, message, title, type.messageType);
        });
    }

    public static void showWaitingMessage(String messageKey, int timeout, Runnable onTimeout) {
        EventQueue.invokeLater(() -> {
            Dialogs.disposeWaitingDialog();
            JOptionPane pane = new JOptionPane(BUNDLE.getString(messageKey), -1, -1, null, new Object[0]);
            waitingDialog = new JDialog(parentFrame, null, true);
            waitingDialog.add(pane);
            waitingDialog.pack();
            waitingDialog.setLocationRelativeTo(parentFrame);
            Dialogs.startCountdown(waitingDialog, timeout, onTimeout);
            waitingDialog.setVisible(true);
        });
    }

    private static void startCountdown(JDialog dialog, int timeout, Runnable onTimeout) {
        SCHEDULER.schedule(() -> EventQueue.invokeLater(() -> {
            dialog.dispose();
            if (waitingDialog == dialog && onTimeout != null) {
                onTimeout.run();
                waitingDialog = null;
            }
        }), (long)timeout, TimeUnit.MILLISECONDS);
    }

    private static void disposeWaitingDialog() {
        if (waitingDialog != null) {
            waitingDialog.dispose();
            waitingDialog = null;
        }
    }

    private Dialogs() {
    }

    static /* synthetic */ ResourceBundle access$100() {
        return BUNDLE;
    }

    public static enum MessageType {
        INFO(Dialogs.access$100().getString("title.info"), 1),
        WARNING(Dialogs.access$100().getString("title.warning"), 2),
        ERROR(Dialogs.access$100().getString("title.error"), 0);

        private final String subtitle;
        private final int messageType;

        private MessageType(String subtitle, int messageType) {
            this.subtitle = subtitle;
            this.messageType = messageType;
        }
    }
}

