/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.imavis.tlc3000.network.client.Dialogs;
import com.imavis.tlc3000.network.client.SendingAddress;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public final class InterfaceDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
    private final List<SendingAddress> sendingAddresses;
    private SendingAddress selectedAddress;
    private JList<String> interfaceList;
    private JScrollPane interfaceListScroll;
    private JLabel label;
    private JButton setButton;

    public InterfaceDialog(List<SendingAddress> sendingAddresses) {
        super((Frame)null, Dialogs.getTitleText(BUNDLE.getString("title")), true);
        this.sendingAddresses = Objects.requireNonNull(sendingAddresses);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.setButton);
        if (!sendingAddresses.isEmpty()) {
            this.interfaceList.setSelectedIndex(0);
        }
    }

    public SendingAddress getSelectedAddress() {
        return this.selectedAddress;
    }

    private void initComponents() {
        this.label = new JLabel();
        this.interfaceListScroll = new JScrollPane();
        this.interfaceList = new JList();
        this.setButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        ResourceBundle bundle = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
        this.label.setText(bundle.getString("label.network_interfaces"));
        this.interfaceList.setModel(new InterfaceListModel());
        this.interfaceList.setSelectionMode(0);
        this.interfaceListScroll.setViewportView(this.interfaceList);
        this.setButton.setText(bundle.getString("button.set"));
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceDialog.this.setButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interfaceListScroll, GroupLayout.Alignment.TRAILING, -1, 643, Short.MAX_VALUE).addComponent(this.label, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.setButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interfaceListScroll, -1, 153, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setButton).addContainerGap()));
        this.pack();
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        int index = this.interfaceList.getSelectedIndex();
        if (index >= 0) {
            this.selectedAddress = this.sendingAddresses.get(index);
        }
        this.dispose();
    }

    private class InterfaceListModel
    extends AbstractListModel<String> {
        private InterfaceListModel() {
        }

        @Override
        public int getSize() {
            return InterfaceDialog.this.sendingAddresses.size();
        }

        @Override
        public String getElementAt(int i) {
            return ((SendingAddress)InterfaceDialog.this.sendingAddresses.get(i)).toString();
        }
    }
}

