/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.imavis.tlc3000.network.client.CamTableModel;
import com.imavis.tlc3000.network.client.Consts;
import com.imavis.tlc3000.network.client.Dialogs;
import com.imavis.tlc3000.network.client.InterfaceDialog;
import com.imavis.tlc3000.network.client.MainFrame;
import com.imavis.tlc3000.network.client.SendingAddress;
import com.imavis.tlc3000.network.client.UDPClient;
import com.imavis.tlc3000.network.client.UDPServer;
import java.awt.EventQueue;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        UDPServer udpServer;
        UDPClient udpClient;
        SendingAddress sendingAddress;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        LOGGER.log(Level.INFO, "client id: {0}", Consts.CLIENT_ID);
        List<SendingAddress> sendingAddresses = SendingAddress.getSendingAddresses();
        if (sendingAddresses.size() == 1) {
            sendingAddress = sendingAddresses.get(0);
        } else {
            FutureTask<SendingAddress> interfaceTask = new FutureTask<SendingAddress>(() -> {
                InterfaceDialog dialog = new InterfaceDialog(sendingAddresses);
                dialog.setVisible(true);
                return dialog.getSelectedAddress();
            });
            EventQueue.invokeLater(interfaceTask);
            sendingAddress = interfaceTask.get();
        }
        if (sendingAddress == null) {
            return;
        }
        CamTableModel camTableModel = new CamTableModel();
        try {
            udpClient = new UDPClient(sendingAddress);
            udpServer = new UDPServer(camTableModel, udpClient);
        }
        catch (SocketException | UnknownHostException ex) {
            return;
        }
        Thread serverThread = new Thread((Runnable)udpServer, "udpServer");
        serverThread.setDaemon(true);
        serverThread.start();
        EventQueue.invokeLater(() -> {
            MainFrame mainFrame = new MainFrame(camTableModel, udpClient);
            Dialogs.setParent(mainFrame);
            mainFrame.scan();
            mainFrame.setVisible(true);
        });
    }
}

