/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.imavis.tlc3000.network.client.CamTableModel;
import com.imavis.tlc3000.network.client.SetDialog;
import com.imavis.tlc3000.network.client.UDPClient;
import com.imavis.tlc3000.network.client.entities.Camera;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;

public class MainFrame
extends JFrame {
    private final CamTableModel camTableModel;
    private final UDPClient udpClient;
    private JTable camTable;
    private JScrollPane camTableScroll;
    private JButton scanButton;
    private JButton setButton;

    public MainFrame(CamTableModel camTableModel, UDPClient udpClient) {
        this.camTableModel = Objects.requireNonNull(camTableModel);
        this.udpClient = Objects.requireNonNull(udpClient);
        this.initComponents();
    }

    public void scan() {
        assert (EventQueue.isDispatchThread());
        this.camTableModel.reset();
        this.udpClient.sendPing();
    }

    private void initComponents() {
        this.camTableScroll = new JScrollPane();
        this.camTable = new JTable();
        this.scanButton = new JButton();
        this.setButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
        this.setTitle(bundle.getString("title"));
        this.camTable.setModel(this.camTableModel);
        this.camTable.setSelectionMode(0);
        this.camTable.getTableHeader().setReorderingAllowed(false);
        this.camTable.getSelectionModel().addListSelectionListener(e -> this.setButton.setEnabled(this.camTable.getSelectedRow() >= 0));
        this.camTableScroll.setViewportView(this.camTable);
        this.scanButton.setText(bundle.getString("button.scan"));
        this.scanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.scanButtonActionPerformed(evt);
            }
        });
        this.setButton.setText(bundle.getString("button.set"));
        this.setButton.setEnabled(false);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.setButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.camTableScroll, -1, 700, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.scanButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setButton).addContainerGap()));
        layout.linkSize(0, this.scanButton, this.setButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.camTableScroll, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanButton).addComponent(this.setButton)).addContainerGap()));
        layout.linkSize(1, this.scanButton, this.setButton);
        this.pack();
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.camTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.camTable.clearSelection();
            Camera camera = this.camTableModel.getCamera(selectedRow);
            SetDialog dialog = new SetDialog(this, camera, this.udpClient);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
    }

    private void scanButtonActionPerformed(ActionEvent evt) {
        this.scan();
    }
}

