/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;

public final class Passwords {
    public static String encryptPassword(char[] password, String key) throws InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException {
        ByteBuffer utf8Password = StandardCharsets.UTF_8.encode(CharBuffer.wrap(password));
        try {
            PublicKey publicKey;
            try {
                byte[] keyBin = DatatypeConverter.parseBase64Binary((String)key);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBin);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (RuntimeException ex) {
                throw new InvalidKeyException("invalid encoded key", ex);
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            byte[] encPassword = cipher.doFinal(utf8Password.array(), utf8Password.position(), utf8Password.limit());
            String string = DatatypeConverter.printBase64Binary((byte[])encPassword);
            return string;
        }
        catch (NoSuchAlgorithmException | BadPaddingException | NoSuchPaddingException ex) {
            throw new AssertionError("unexpected error", ex);
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(utf8Password.array(), (byte)0);
        }
    }

    private Passwords() {
    }
}

